/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.command;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import lotr.common.LOTRLevelData;
import lotr.common.fac.LOTRFaction;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.PlayerNotFoundException;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;

public class LOTRCommandAlignment
extends CommandBase {
    public String func_71517_b() {
        return "alignment";
    }

    public int func_82362_a() {
        return 2;
    }

    public String func_71518_a(ICommandSender sender) {
        return "commands.lotr.alignment.usage";
    }

    public void func_71515_b(ICommandSender sender, String[] args) {
        if (args.length >= 2) {
            EntityPlayerMP entityplayer;
            List<Object> factions = new ArrayList();
            if (args[1].equalsIgnoreCase("all")) {
                factions = LOTRFaction.getPlayableAlignmentFactions();
            } else {
                LOTRFaction faction = LOTRFaction.forName(args[1]);
                if (faction == null) {
                    throw new WrongUsageException("commands.lotr.alignment.noFaction", new Object[]{args[1]});
                }
                factions.add((Object)faction);
            }
            if (args[0].equals("set")) {
                float alignment = (float)CommandBase.func_110661_a((ICommandSender)sender, (String)args[2], (double)-1.0E7, (double)1.0E7);
                if (args.length >= 4) {
                    entityplayer = CommandBase.func_82359_c((ICommandSender)sender, (String)args[3]);
                } else {
                    entityplayer = CommandBase.func_71521_c((ICommandSender)sender);
                    if (entityplayer == null) {
                        throw new PlayerNotFoundException();
                    }
                }
                for (LOTRFaction lOTRFaction : factions) {
                    LOTRLevelData.getData((EntityPlayer)entityplayer).setAlignmentFromCommand(lOTRFaction, alignment);
                    CommandBase.func_152373_a((ICommandSender)sender, (ICommand)this, (String)"commands.lotr.alignment.set", (Object[])new Object[]{entityplayer.func_70005_c_(), lOTRFaction.factionName(), Float.valueOf(alignment)});
                }
                return;
            }
            if (args[0].equals("add")) {
                float newAlignment;
                float alignment = (float)CommandBase.func_82363_b((ICommandSender)sender, (String)args[2]);
                if (args.length >= 4) {
                    entityplayer = CommandBase.func_82359_c((ICommandSender)sender, (String)args[3]);
                } else {
                    entityplayer = CommandBase.func_71521_c((ICommandSender)sender);
                    if (entityplayer == null) {
                        throw new PlayerNotFoundException();
                    }
                }
                HashMap<LOTRFaction, Float> hashMap = new HashMap<LOTRFaction, Float>();
                for (LOTRFaction lOTRFaction : factions) {
                    newAlignment = LOTRLevelData.getData((EntityPlayer)entityplayer).getAlignment(lOTRFaction) + alignment;
                    if (newAlignment < -1.0E7f) {
                        throw new WrongUsageException("commands.lotr.alignment.tooLow", new Object[]{Float.valueOf(-1.0E7f)});
                    }
                    if (newAlignment > 1.0E7f) {
                        throw new WrongUsageException("commands.lotr.alignment.tooHigh", new Object[]{Float.valueOf(1.0E7f)});
                    }
                    hashMap.put(lOTRFaction, Float.valueOf(newAlignment));
                }
                for (LOTRFaction lOTRFaction : factions) {
                    newAlignment = ((Float)hashMap.get((Object)lOTRFaction)).floatValue();
                    LOTRLevelData.getData((EntityPlayer)entityplayer).addAlignmentFromCommand(lOTRFaction, alignment);
                    CommandBase.func_152373_a((ICommandSender)sender, (ICommand)this, (String)"commands.lotr.alignment.add", (Object[])new Object[]{Float.valueOf(alignment), entityplayer.func_70005_c_(), lOTRFaction.factionName()});
                }
                return;
            }
        }
        throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
    }

    public List func_71516_a(ICommandSender sender, String[] args) {
        if (args.length == 1) {
            return CommandBase.func_71530_a((String[])args, (String[])new String[]{"set", "add"});
        }
        if (args.length == 2) {
            List<String> list = LOTRFaction.getPlayableAlignmentFactionNames();
            list.add("all");
            return CommandBase.func_71530_a((String[])args, (String[])list.toArray(new String[0]));
        }
        if (args.length == 4) {
            return CommandBase.func_71530_a((String[])args, (String[])MinecraftServer.func_71276_C().func_71213_z());
        }
        return null;
    }

    public boolean func_82358_a(String[] args, int i) {
        return i == 3;
    }
}

